<?php
//http://wp.tutsplus.com/articles/getting-started-with-ajax-wordpress-pagination/

add_action( 'init', 'my_enqueue' );
function my_enqueue($hook) 
{        
	if(!is_admin()){		
		wp_enqueue_script( 'ajax-script', plugins_url( 'ajax.js', __FILE__ ), array('jquery'));				
		$translations = array();
		$translations['ajax_url'] = admin_url( 'admin-ajax.php' );
		$translations['user_id'] = get_current_user_id();
		$translations['post_id'] = url_to_postid($_SERVER['REQUEST_URI']);
		
		$translations['post_succesfully_sent'] 	= __('This post was successfully sent by email to','ainia');
		$translations['mail_not_sent'] 			= __('Error. E-mail has not been sent.','ainia');
		$translations['could_not_classify'] 	= __('Error. Could not classify post.','ainia'); ;
		$translations['correctly_classified'] 	= __('This post was classified correctly in category','ainia');
		$translations['added_to_favourites'] 	= __('Post was added to favourites list.','ainia');
		$translations['removed_from_favourites']= __('Post was removed from favourites list.','ainia');		
		$translations['is_favourite'] 			= __('Is Favourite!','ainia');
		$translations['remove'] 				= __('Remove','ainia');
		$translations['is_not_favourite'] 		= __('Not Favourite','ainia');
		$translations['add'] 					= __('Add','ainia');
		$translations['action_not_done'] 		= __('Error. Action was not done.','ainia');
		$translations['recommendation_not_sent']= __('Error. Recommendation has not been sent.','ainia');
		$translations['recommendation_sent'] 	= __('A recommendation email has been sent to','ainia');
		
		$translations['error_color'] 	= '#FF9999';
		$translations['success_color'] 	= '#99FF99';
				
		wp_localize_script( 'ajax-script', 'ajax_object', $translations );
		}
}

// Same handler function...
add_action('wp_ajax_send_email', 'ajax_send_email');
function ajax_send_email() 
{	
	$to = $_POST['to'];
	$user_id = intval($_POST['user_id']);
	$post_id = intval($_POST['post_id']) ;	
	$user = get_userdata( $user_id );
	$subject = $user->display_name . __(" recommends a link to you.",'ainia');
	$body = sprintf( __("This is an automatic email. %s recomends you this link: <a href='%s'>%s</a>",'ainia'),
					$user->display_name,
					/*get_permalink($post_id)*/ get_post_meta( $post_id, 'url_article', true ),
					get_the_title($post_id));	
	$headers = sprintf("From: %s <%s> \r\n",$user->display_name,$user->user_email);
	$headers .= sprintf("Reply-To: %s \r\n",$user->user_email);
	$headers .= "MIME-Version: 1.0\r\n";
	$headers .= "Content-Type: text/html; charset=UTF-8\r\n";	
	add_extended_user_email_to($user_id,"hoy",$to,$subject,$body);		
	$result  = wp_mail($to,$subject,$body,$headers);
	die( $result ? 'OK' : "Error" );
}


add_action('wp_ajax_categorize', 'ajax_categorize');
function ajax_categorize() 
{	
	$user_id = intval($_POST['user_id']) ;
	$post_id = intval($_POST['post_id']) ;		
	$cat_id  = intval($_POST['cat']) ;		
	$term = get_term($cat_id,"category");
	if(!$term || is_wp_error($term) || !get_post($post_id) ) die('Error');	
	add_extended_user_categorize($post_id,$cat_id,$user_id);
	
	$cats = wp_get_post_categories($post_id);
	if(!in_array($cat_id,$cats))$cats[]=$cat_id;
	wp_set_post_categories( $post_id, $cats );
	
	die(sprintf('<a href="%s">%s</a>',get_term_link($term),$term->name));
}

add_action('wp_ajax_projectualize', 'ajax_projectualize');
function ajax_projectualize() 
{	
	$user_id = intval($_POST['user_id']) ;
	$post_id = intval($_POST['post_id']) ;		
	$proj_id  = intval($_POST['proj']) ;		
	$term = get_term($proj_id,"proyecto");	
	if(!$term || is_wp_error($term) || !get_post($post_id) ) die('Error');	
	$proj_name = $term->name;
	//add_extended_user_categorize($post_id,$proj_id,$user_id);
	
	$projs = wp_get_post_terms($post_id,'proyecto');
	$proj_names = array();
	foreach($projs as $pr)$proj_names[]=$pr->name;
	if(!in_array($proj_name,$proj_names))$proj_names[]=$proj_name;
	wp_set_post_terms( $post_id, $proj_names, 'proyecto' );
	
	die(sprintf('<a href="%s">%s</a>',get_term_link($term),$term->name));
}

add_action('wp_ajax_favorite', 'ajax_favorite');
function ajax_favorite() 
{	
	$post_id = intval($_POST['post_id']) ;		
	$user_id = intval($_POST['user_id']) ;
	if(!get_post($post_id)||!get_userdata( $user_id ))die('Error');
	$rel = get_user_relation_id( $user_id , 0, $post_id, 'favorite' );	
	if($rel){
		delete_user_relation($rel);
		die("removed");
	}
	else {
		add_extended_user_favorite($post_id,$user_id);	
		die("added");
	}
}

add_action('wp_ajax_recommend', 'ajax_recommend');
function ajax_recommend() 
{		
	$user_from = $_POST['user_id'] ;
	$user_to   = $_POST['user_to'] ;
	$post_id   = $_POST['post_id'] ;			
	
	if( !get_userdata( $user_from ) || !get_userdata( $user_to ) || !get_post($post_id) )die('Error');	
	
	add_extended_user_recommend($post_id,$user_to);
	add_extended_user_recommended($post_id,$user_to,$user_from);		
	
	$destinatario = get_userdata( $user_to );
	die( $destinatario->display_name);
}

//add_shortcode ('prueba_ajax','prueba_ajax');
function prueba_ajax($content)
{  
	global $post;
	if(!is_single()) return get_string_max_length($content,400);
	
	ob_start();

	?>  
		<div class="ainia-downloads">
			<?php echo ainia_post_attachments($post);?>
		</div>
	
		 <div class="ainia-actions">
		 			 
			 <p class="action_category">
			 <?php _e( 'Categorized in&#58; ','ainia');?><span class="category_list"><?php the_category(', ');?></span>
			 -
			 <?php wp_dropdown_categories(array('hierarchical'=>1,'hide_empty'=>false,'exclude'=>wp_get_post_categories($post->ID)));?>
			 <input type="button" value="<?php _e('Add Category','ainia');?>" id="categorizar">
			 </p>
			 
			 <?php $tags=wp_get_post_tags($post->ID);			 
			 if(count($tags)):?>	
			 <p class="action_tags"><?php the_tags(__( 'Tagged as: ','ainia')." ",', '); ?></p>
			 <?php endif;?>
			 
			 <p class="action_projects"><span class="project_list">			 
			 <?php $terms=wp_get_post_terms($post->ID,'proyecto');			 
				   $terms_ids = array();foreach($terms as $term) $terms_ids[]=$term->term_id;
				   if(count($terms))the_terms($post->ID,'proyecto',__( 'In Project: ','ainia')." ",', '); 				   
			 ?></span> -
			 <?php wp_dropdown_categories(array('name'=>'proj','taxonomy'=>'proyecto','exclude'=>$terms_ids,'hide_empty'=>false));?>
			 <input type="button" value="<?php _e('Add to Project','ainia');?>" id="proyectualizar">
			 </p>
			 <br/>			 
			 
			 <?php
			 $url_article = get_post_meta( $post->ID, 'url_article', true );
  			 $terms=wp_get_post_terms($post->ID,"fuente");			 
			 if(count($terms)):?>			 
			 <p class="action_source">
			 <?php _e( 'Source&#58;','ainia'); ?>
			 <a href="<?php echo get_term_link($terms[0],'fuente')?>"><?php echo $terms[0]->name;?></a> | 
			 <a href="<?php echo $url_article;?>"><?php _e( 'Read Original&raquo;','ainia');?></a>
			 </p>			 
			 <?php endif;?>			 			 
			 
			 <p class="date action_date"><?php ainia_posted_on();?></p>
			 
			 <p class="action_readed"><?php printf(__('%d times readed','ainia'), get_count_of_object_by_user_relation($post->ID,"browse"));?></p>
			 			 			 		 			 
			 <?php edit_post_link( __( 'Edit Post','ainia'), '<p class="action_edit">', '</p>' ); ?>
			 
			 <br/>
			 		 
			 			 
			 <p class="action_favorito">
			 <?php
				$rel = get_user_relation_id( get_current_user_id() , 0, $post->ID, 'favorite' );				
				if($rel):?>		
					<span id="esFavorito"><?php _e('Is Favorite!','ainia');?></span>
					<input type="button" value="<?php _e('Remove','ainia');?>" id="marcarFavorito"></p>			 					
			 <?php else: ?>
					<span id="esFavorito"><?php _e('Not Favorite','ainia');?></span>
					<input type="button" value="<?php _e('Add','ainia');?>" id="marcarFavorito"></p>			 	    
			 <?php endif; ?>
			 		 
			 <p class="action_recommend">
			 <?php _e('Recommend to:','ainia');?>
			 <?php wp_dropdown_users(array('show_option_none' => '-','exclude'=>array(1)));?>
			 <input type="button" value="<?php _e('Send','ainia');?>" id="recomendar">
			 </p>
			 
			 <p class="action_email">
			 <?php _e('Send to:','ainia');?>
			 <input type="text" value="email" id="email_to" style="width:auto" size="20">
			 <input type="button" value="<?php _e('Send E-Mail','ainia');?>" id="enviar_mail"></p>
			
			 <br/><br/><p id="server_message" style="display:none">Esto es un mensaje</p>
			 
			 
					 
		</div>
	<?php
	
	
	$metadata = ob_get_contents();
	ob_end_clean();
	return $content . $metadata;
}

add_action('the_content','prueba_ajax');



